;ENUNCIATO:
;Un parcheggio automatico con capienza massima di 40 automobili  provvisto
;di 2 sbarre che ne regolano: la prima le entrate e la seconda le uscite. 
;Due coppie di sensori rilevano il passaggio dei veicoli ed azionano le
;rispettive sbarre restano aperte per il tempo necessario al transito del
;veicolo. Quando non ci sono posti liberi la sbarra di entrata non si apre.
;Un sistema luminoso segnala tramite l'accensione di una luce verde la 
;disponibilit di posto nel parcheggio.La luce rossa segnala il tutto esaurito. 
;Dopo aver effettuato eventuali ipotesi aggiuntive, realizzare il diagramma 
;di flusso e il rispettivo linguaggio assembly.
;_____________________________________________________________________________
;
;ASSEGNAZIONE
;
;P1.0 -> SENSORE IN
;P1.1 -> SENSORE OUT
;P1.2 -> SBARRA IN  ; ATT BASSO
;P1.3 -> SBARRA OUT ; ATT BASSO
;P1.4 -> LUCE VERDE ; ATT BASSO
;P1.5 -> LUCE ROSSA ; ATT BASSO
;
;_____________________________________________________________________________
; ASSEMBLY 8051
;_____________________________________________________________________________
;
        $MOD51            
        ORG 1000H
INIZIO: SETB P1.2      ;CHIUDO SBARRA DI ENTRATA
        SETB P1.3      ;CHIUDO SBARRA DI USCITA
        SETB P1.4      ;SPENGO LA LUCE VERDE
        SETB P1.5      ;SPENGO LA LUCE ROSSA
        MOV 50H,#40    ;INIZIALIZZO UN CONTATORE SPOSTANDO 40 ALL'INDIRIZZO 50H
IST1: MOV A,50H        ;SPOSTO IL NUMERO PRESENTE IN 50H NELL'ACCUMULATORE
      JZ IST6          ;SALTO ALL'INDIRIZZO IST6 SE IL NUM PRESENTE NELL'ACC =0
IST2: CLR P1.4         ;ACCENDO LUCE VERDE
      SETB P1.5        ;SPENGO LUCE ROSSA
      JNB P1.0,IST4    ;SE IL SENSORE IN  = A 0 SALTO ALL'INDIRIZZO IST4
      CLR P1.2         ;APRO LA SBARRA DI ENTRATA
;------------------------------------------------------------------------------
RITARDO: MOV R0,#100   ;RITARDO
RIT2: MOV R1,#100      ;RITARDO
RIT1: MOV R2,#50       ;RITARDO
      DJNZ R2,$        ;RITARDO
      DJNZ R1,RIT1     ;RITARDO
      DJNZ R0,RIT2     ;RITARDO
;------------------------------------------------------------------------------
IST3: SETB P1.2        ;CHIUDO LA SBARRA DI ENTRATA
      DJNZ 50H,IST1    ;DECREMENTO IL NUM PRESENTE IN 50H E SALTO ALL'INDIRIZZO IST1
IST4: JNB P1.1,IST1    ;SE IL SENSORE DI USCITA  = A 0 SALTA ALL'INDIRIZZO IST1
      CLR P1.3         ;APRO LA SBARRA DI USCITA
;------------------------------------------------------------------------------
RITB: MOV R0,#100      ;RITARDO
RITS: MOV R1,#100      ;RITARDO
RITG: MOV R2,#50       ;RITARDO
      DJNZ R2,$        ;RITARDO
      DJNZ R1,RITG     ;RITARDO
      DJNZ R0,RITS     ;RITARDO
;------------------------------------------------------------------------------
IST5: SETB P1.3        ;CHIUDO LA SBARRA DI USCITA
      INC 50H          ;INCREMENTO IL CONTATORE
      AJMP IST1        ;SALTO ALL'INDIRIZZO IST1
IST6: CLR P1.5         ;ACCENDO LA LUCE ROSSA
      SETB P1.4        ;SPENGO LA LUCE VERDE
      AJMP IST4        ;SALTO ALL'INDIRIZZO IST4

